/*
 * Decompiled with CFR 0.152.
 */
package org.labellum.mc.dynamictreestfc;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.Random;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.api.util.ITreeGenerator;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.blocks.wood.BlockSaplingTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.TemplateManager;
import org.labellum.mc.dynamictreestfc.ModTrees;
import org.labellum.mc.dynamictreestfc.trees.TreeFamilyTFC;

public class DTTFCGenerator
implements ITreeGenerator {
    private int leavesRadius = 0;

    public void generateTree(TemplateManager templateManager, World world, BlockPos blockPos, Tree tree, Random random, boolean isWorldGen) {
        Species dtSpecies = ModTrees.tfcSpecies.get(tree.toString());
        SafeChunkBounds bounds = new SafeChunkBounds(world, world.func_175726_f(blockPos).func_76632_l());
        dtSpecies.generate(world, blockPos.func_177977_b(), world.func_180494_b(blockPos), random, this.leavesRadius <= 0 ? dtSpecies.maxBranchRadius() / 3 : this.leavesRadius, bounds);
    }

    public boolean canGenerateTree(World world, BlockPos pos, Tree treeType) {
        if (!BlocksTFC.isGrowableSoil((IBlockState)world.func_180495_p(pos.func_177977_b()))) {
            return false;
        }
        IBlockState locState = world.func_180495_p(pos);
        if (locState.func_185904_a().func_76224_d() || !locState.func_185904_a().func_76222_j() && !(locState.func_177230_c() instanceof BlockSaplingTFC)) {
            return false;
        }
        Species dTree = ModTrees.tfcSpecies.get(treeType.toString());
        int lowestBranchHeight = dTree.getLowestBranchHeight();
        int maxTreeHeight = (int)((TreeFamilyTFC.TreeTFCSpecies)dTree).getSignalEnergy();
        SafeChunkBounds bounds = new SafeChunkBounds(world, world.func_175726_f(pos).func_76632_l());
        for (int y = 0; y <= lowestBranchHeight; ++y) {
            if (this.isValidLocation(world, pos.func_177981_b(y), 0, 0, bounds)) continue;
            return false;
        }
        this.leavesRadius = (int)Math.ceil((1.0f - ChunkDataTFC.get((World)world, (BlockPos)pos).getFloraDensity()) * 5.0f) + 2;
        int radiusSquared = this.leavesRadius * this.leavesRadius;
        int groundToCenter = (int)((float)(maxTreeHeight - lowestBranchHeight) / 2.0f) + lowestBranchHeight;
        for (int x = -this.leavesRadius - 1; x <= this.leavesRadius + 1; ++x) {
            for (int z = -this.leavesRadius - 1; z <= this.leavesRadius + 1; ++z) {
                for (int y = lowestBranchHeight - 1; y < maxTreeHeight; ++y) {
                    int yDistance = groundToCenter - y;
                    if (x * x + yDistance * yDistance + z * z > radiusSquared || this.isValidLocation(world, pos.func_177981_b(y), x, z, bounds)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidLocation(World world, BlockPos pos, int x, int y, SafeChunkBounds bounds) {
        boolean origin = x == 0 && y == 0;
        return origin || !bounds.inBounds(pos.func_177982_a(x, 0, y), false) || this.isReplaceable(world, pos, x, 0, y) || (x > 1 || y > 1) && this.isReplaceable(world, pos, x, 1, y);
    }

    private boolean isDTBranch(IBlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BlockBranch;
    }

    private boolean isReplaceable(World world, BlockPos pos, int x, int y, int z) {
        IBlockState state = world.func_180495_p(pos.func_177982_a(x, y, z));
        return state.func_185904_a().func_76222_j() && !this.isDTBranch(state);
    }
}

